# Installation

Run `composer require dedi/sylius-quote-plugin`

Add the plugin and dependency classes to your `config/bundles.php` :

```php
<?php

return [
    //..
    Dedi\SyliusQuotePlugin\DediSyliusQuotePlugin::class => ['all' => true],
    Sylius\Bundle\GridBundle\SyliusGridBundle::class => ['all' => true],
    winzou\Bundle\StateMachineBundle\winzouStateMachineBundle::class => ['all' => true],
    // ..
];
```

Create `dedi_sylius_quote_plugin.yaml` file into `config/packages` folder to import the plugin's config

```yaml
# config/packages/dedi_sylius_quote_plugin.yaml
imports:
    - { resource: "@DediSyliusQuotePlugin/Resources/config/config.yaml" }
```

### Import the routes

```yaml
# config/routes/sylius_shop.yaml

...

dedi_sylius_quote_plugin:
    resource: "@DediSyliusQuotePlugin/Resources/config/shop_routing.yml"
```

```yaml
# config/routes/sylius_admin.yaml

...

dedi_sylius_quote_plugin:
    resource: "@DediSyliusQuotePlugin/Resources/config/admin_routing.yml"
```

### Install Assets
```bash
    bin/console assets:install
```

### Extending Sylius' entities

#### Order
```php
    use Dedi\SyliusQuotePlugin\Entity\OrderInterface;
    use Dedi\SyliusQuotePlugin\Entity\QuoteOrderTrait;
    use Doctrine\ORM\Mapping as ORM;
    use Sylius\Component\Core\Model\Order as BaseOrder;

    /**
    * @ORM\Entity
    * @ORM\Table(name="sylius_order")
    */
    class Order extends BaseOrder implements OrderInterface
    {
        use QuoteOrderTrait;
    }
```

#### OrderItem

```php
    use Dedi\SyliusQuotePlugin\Entity\OrderItemInterface;
    use Dedi\SyliusQuotePlugin\Entity\QuoteOrderItemTrait;
    use Doctrine\ORM\Mapping as ORM;
    use Sylius\Component\Core\Model\OrderItem as BaseOrderItem;

    /**
    * @ORM\Entity
    * @ORM\Table(name="sylius_order_item")
    */
    class OrderItem extends BaseOrderItem implements OrderItemInterface
    {
        use QuoteOrderItemTrait;
    }
```

### Create and execute database migrations

```bash
    bin/console doctrine:migrations:diff
    bin/console doctrine:migrations:migrate
```

## Import Webpack Config
<br>

1. Import plugin's `webpack.config.js` file

```js
// webpack.config.js
const [ dediQuoteShop, dediQuoteAdmin ] = require('./vendor/dedi/sylius-quote-plugin/webpack.config.js')
...

module.exports = [..., dediQuoteShop, dediQuoteAdmin];
```

2. Add new packages in `./config/packages/assets.yaml`

```yml
# config/packages/assets.yaml

framework:
    assets:
        packages:
            # ...
            quote_shop:
                json_manifest_path: '%kernel.project_dir%/public/build/dedi-plugin/quote/shop/manifest.json'
            quote_admin:
                json_manifest_path: '%kernel.project_dir%/public/build/dedi-plugin/quote/admin/manifest.json'
```

3. Add new build paths in `./config/packages/webpack_encore.yml`

```yml
# config/packages/webpack_encore.yml

webpack_encore:
    builds:
        # ...
        quote_shop: '%kernel.project_dir%/public/build/dedi-plugin/quote/shop'
        quote_admin: '%kernel.project_dir%/public/build/dedi-plugin/quote/admin'
```
