const path = require('path');
const Encore = require('@symfony/webpack-encore');
const pluginName = 'order-status-history';

const getConfig = (pluginName, type) => {
    Encore.reset();

    Encore.setOutputPath(`public/build/dedi-plugin/${pluginName}/${type}/`)
        .setPublicPath(`/build/dedi-plugin/${pluginName}/${type}/`)
        .addEntry(`dedi-${pluginName}-${type}`, path.resolve(__dirname, `./assets/${type}/entry.js`))
        .disableSingleRuntimeChunk()
        .cleanupOutputBeforeBuild()
        .enableSourceMaps(!Encore.isProduction())
        .enableSassLoader();

    const config = Encore.getWebpackConfig();
    config.name = `dedi-${pluginName}-${type}`;

    return config;
};

Encore.setOutputPath(`src/Resources/public/build/`)
    .setPublicPath(`/public/build/`)
    .addEntry(`dedi-${pluginName}-admin`, path.resolve(__dirname, `.assets/admin/entry.js`))
    .cleanupOutputBeforeBuild()
    .disableSingleRuntimeChunk()
    .enableSassLoader();

const distConfig = Encore.getWebpackConfig();
distConfig.name = `dedi-plugin-dist`;

Encore.reset();

const adminConfig = getConfig(pluginName, 'admin');

module.exports = [adminConfig, distConfig];
