<?php

declare(strict_types=1);

namespace Dedi\SyliusOrderStatusHistoryPlugin\Model;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

trait OrderStatusHistoryAware
{
    #[ORM\OneToMany(targetEntity: 'Dedi\SyliusOrderStatusHistoryPlugin\Entity\OrderStatusHistoryInterface', mappedBy: 'order')]
    #[ORM\OrderBy(['createdAt' => 'ASC'])]
    private Collection $statusesHistory;

    public function __construct()
    {
        $this->statusesHistory = new ArrayCollection();
    }

    public function getStatusesHistory(): Collection
    {
        return $this->statusesHistory;
    }
}
