<?php

declare(strict_types=1);

namespace Dedi\SyliusOrderStatusHistoryPlugin\Entity;

use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Resource\Model\ResourceInterface;

interface OrderStatusHistoryInterface extends ResourceInterface
{
    public function getOrder(): ?OrderInterface;

    public function setOrder(?OrderInterface $order): static;

    public function getState(): ?string;

    public function setState(?string $state): static;

    public function getPaymentState(): ?string;

    public function setPaymentState(?string $paymentState): static;

    public function getShippingState(): ?string;

    public function setShippingState(?string $shippingState): static;

    public function getUrl(): ?string;

    public function setUrl(?string $url): static;

    public function getTransition(): ?string;

    public function setTransition(?string $transition): static;

    public function getStateMachineName(): ?string;

    public function setStateMachineName(?string $stateMachineName): static;

    public function getPreviousState(): ?string;

    public function setPreviousState(?string $previousState): static;
}
