<?php

declare(strict_types=1);

namespace Dedi\SyliusOrderStatusHistoryPlugin\Entity;

use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Resource\Model\TimestampableTrait;

class OrderStatusHistory implements OrderStatusHistoryInterface
{
    use TimestampableTrait;

    protected ?int $id;

    protected ?OrderInterface $order;

    protected ?string $state = null;

    protected ?string $paymentState = null;

    protected ?string $shippingState = null;

    protected ?string $url = null;

    protected ?string $transition = null;

    protected ?string $stateMachineName = null;

    protected ?string $previousState = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getOrder(): ?OrderInterface
    {
        return $this->order;
    }

    public function setOrder(?OrderInterface $order): static
    {
        $this->order = $order;

        return $this;
    }

    public function getState(): ?string
    {
        return $this->state;
    }

    public function setState(?string $state): static
    {
        $this->state = $state;

        return $this;
    }

    public function getPaymentState(): ?string
    {
        return $this->paymentState;
    }

    public function setPaymentState(?string $paymentState): static
    {
        $this->paymentState = $paymentState;

        return $this;
    }

    public function getShippingState(): ?string
    {
        return $this->shippingState;
    }

    public function setShippingState(?string $shippingState): static
    {
        $this->shippingState = $shippingState;

        return $this;
    }

    public function getUrl(): ?string
    {
        return $this->url;
    }

    public function setUrl(?string $url): static
    {
        $this->url = $url;

        return $this;
    }

    public function getTransition(): ?string
    {
        return $this->transition;
    }

    public function setTransition(?string $transition): static
    {
        $this->transition = $transition;

        return $this;
    }

    public function getStateMachineName(): ?string
    {
        return $this->stateMachineName;
    }

    public function setStateMachineName(?string $stateMachineName): static
    {
        $this->stateMachineName = $stateMachineName;

        return $this;
    }

    public function getPreviousState(): ?string
    {
        return $this->previousState;
    }

    public function setPreviousState(?string $previousState): static
    {
        $this->previousState = $previousState;

        return $this;
    }
}
