<?php

declare(strict_types=1);

namespace Dedi\SyliusOrderStatusHistoryPlugin\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    /**
     * @psalm-suppress UnusedVariable
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('dedi_sylius_order_status_history');
        $rootNode = $treeBuilder->getRootNode();

        $this->addConfiguration($rootNode);

        return $treeBuilder;
    }

    private function addConfiguration(ArrayNodeDefinition $node): void
    {
        $node
            ->children()
                ->scalarNode('enabled')
                ->defaultValue(true)
            ->end()
        ;
    }
}
