<?php

declare(strict_types=1);

namespace Dedi\SyliusOrderStatusHistoryPlugin\Api\Admin\Controller;

use Dedi\SyliusOrderStatusHistoryPlugin\Model\OrderStatusHistoryAwareInterface;
use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Repository\OrderRepositoryInterface;
use Webmozart\Assert\Assert;

class OrderStatusAction
{
    public function __construct(private readonly OrderRepositoryInterface $orderRepository)
    {
    }

    public function __invoke(string $tokenValue): Collection
    {
        $order = $this->orderRepository->findOneByTokenValue($tokenValue);
        Assert::isInstanceOf($order, OrderStatusHistoryAwareInterface::class);

        return $order->getStatusesHistory();
    }
}
