# Installation

Run `composer require dedi/sylius-order-status-history-plugin`

Add plugin class to your `config/bundles.php`:

```php
<?php
$bundles = [
    // ...
    Dedi\SyliusOrderStatusHistoryPlugin\DediSyliusOrderStatusHistoryPlugin::class => ['all' => true],
    // ...
];
```

## Import the plugin configuration

```yaml
# config/packages/dedi_sylius_order_status_history_plugin.yaml

imports:
  - { resource: "@DediSyliusOrderStatusHistoryPlugin/config/config.yaml" }

```

### Import api resources

```xml
<!-- config/api_platform/Order.xml -->

<itemOperations>
    ...
    <itemOperation name="admin_get_status_history">
        <attribute name="method">GET</attribute>
        <attribute name="path">/admin/orders/{tokenValue}/status-history</attribute>
        <attribute name="controller">dedi_sylius_order_status_history_plugin.api.admin.controller.order_status</attribute>
        <attribute name="normalization_context">
            <attribute name="groups">admin:order_status_history:read</attribute>
        </attribute>
        <attribute name="openapi_context">
            <attribute name="summary">Retrieves order status history</attribute>
            <attribute name="parameters">
                <attribute>
                    <attribute name="name">tokenValue</attribute>
                    <attribute name="in">path</attribute>
                    <attribute name="required">true</attribute>
                    <attribute name="schema">
                        <attribute name="type">string</attribute>
                    </attribute>
                </attribute>
            </attribute>
        </attribute>
    </itemOperation>
</itemOperations>
```

## Use Order trait and interfaces

```php
<?php

namespace App\Entity;

use Dedi\SyliusOrderStatusHistoryPlugin\Model\OrderStatusHistoryAware;
use Dedi\SyliusOrderStatusHistoryPlugin\Model\OrderStatusHistoryAwareInterface;
use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\Order as BaseOrder;

/**
 * @ORM\Entity
 * @ORM\Table(name="sylius_order")
 */
class Order extends BaseOrder implements OrderStatusHistoryAwareInterface
{
    use OrderStatusHistoryAware {
        __construct as private initializeStatusesHistory;
    }

    public function __construct()
    {
        parent::__construct();

        $this->initializeStatusesHistory();
    }
}

```

## Override Order resource

```yaml
sylius_order:
    resources:
        order:
            classes:
                model: App\Entity\Order
```

## Add webpack configuration

```yaml
# config/packages/webpack_encore.yaml

webpack_encore:
    builds:
        ...
        dedi_order_status_history: '%kernel.project_dir%/public/build/dedi-plugin/order-status-history'
```

```yaml
# config/packages/assets.yaml
framework:
    assets:
        packages:
            ...
            dedi_order_status_history:
                json_manifest_path: '%kernel.project_dir%/public/build/dedi-plugin/order-status-history/manifest.json'

```

```js
// webpack.config.js

const [dediOrderStatusHistoryAdmin] = require('./vendor/dedi/sylius-order-status-history-plugin/webpack.config.js')
...

module.exports = [..., dediOrderStatusHistoryAdmin];
```

## Run migrations

```
bin/console doctrine:migration:diff
bin/console doctrine:migration:migrate
````
