<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Twig;

use Sylius\Component\Resource\Repository\RepositoryInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

final class MenuFetcherExtension extends AbstractExtension
{
    private readonly RepositoryInterface $menuRepository;

    public function __construct(
        RepositoryInterface $menuRepository,
    ) {
        $this->menuRepository = $menuRepository;
    }

    public function getFunctions()
    {
        return [
            new TwigFunction('dedi_megamenu_fetch_menus', [$this->menuRepository, 'findAll']),
        ];
    }
}
