<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Repository\Taxon;

use Doctrine\ORM\QueryBuilder;

trait TaxonRepositoryTrait
{
    public function createFindFirstLevelQueryBuilder(): QueryBuilder
    {
        return $this->createQueryBuilder('o')
            ->leftJoin('o.parent', 'p')
            ->where('o.parent IS NULL')
            ->orWhere('p.parent IS NULL')
            ->addOrderBy('o.position')
        ;
    }
}
