<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Repository;

use Dedi\SyliusMegamenuPlugin\Entity\MenuInterface;
use Sylius\Component\Core\Model\ChannelInterface;

final class MenuRepository extends EntryRepository implements MenuRepositoryInterface
{
    public function findForChannel(ChannelInterface $channel): ?MenuInterface
    {
        return $this
            ->createQueryBuilder('o')
            ->join('o.channel', 'c')
            ->andWhere('c.id = :channelId')
            ->setParameter('channelId', $channel->getId())
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
}
