<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Repository;

use Dedi\SyliusMegamenuPlugin\Entity\EntryInterface;
use Sylius\Bundle\ResourceBundle\Doctrine\ORM\EntityRepository;

class EntryRepository extends EntityRepository implements EntryRepositoryInterface
{
    public function findOneByIdAndMenuId($id, $menuId): ?EntryInterface
    {
        return $this
            ->createQueryBuilder('o')
            ->join('o.menu', 'm')
            ->andWhere('o.id = :id')
            ->andWhere('m.id = :menuId')
            ->setParameter('id', $id)
            ->setParameter('menuId', $menuId)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
}
