<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Form\Type;

use Dedi\SyliusMegamenuPlugin\Form\Listener\AdAwareInterface;
use Dedi\SyliusMegamenuPlugin\Form\Listener\AdFileUploaderInterface;
use LogicException;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class AdType extends AbstractType
{
    private readonly AdFileUploaderInterface $fileUploader;

    public function __construct(
        AdFileUploaderInterface $fileUploader,
    ) {
        $this->fileUploader = $fileUploader;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('file', FileType::class, [
                'label' => 'sylius.form.image.file',
                'required' => false,
                'mapped' => false,
            ])
            ->add('url', UrlType::class, [
                'label' => 'dedi_megamenu.ui.url',
                'property_path' => 'adUrl',
                'required' => false,
            ])
            ->add('removeFile', CheckboxType::class, [
                'label' => 'dedi_megamenu.ui.remove_file',
                'required' => false,
                'mapped' => false,
            ])
            ->addEventListener(FormEvents::POST_SUBMIT, [$this->fileUploader, 'handleFileUpload'])
        ;
    }

    public function buildView(FormView $view, FormInterface $form, array $options): void
    {
        $fileAware = $form->getData();
        if (null === $fileAware) {
            return;
        }

        if (!$fileAware instanceof AdAwareInterface) {
            throw new LogicException(sprintf(
                'Expected object of type "%s", got "%s"',
                AdAwareInterface::class,
                get_class($fileAware),
            ));
        }

        $view->vars['image'] = $fileAware->getAdImage();
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'inherit_data' => true,
        ]);
    }
}
