<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\EventListener;

use Dedi\SyliusMegamenuPlugin\Entity\Entry;
use Doctrine\ORM\Event\LoadClassMetadataEventArgs;
use LogicException;

class DiscriminatorMapListener
{
    private iterable $menuEntries;

    public function __construct(iterable $menuEntries)
    {
        $this->menuEntries = $menuEntries instanceof \Traversable ? iterator_to_array($menuEntries) : $menuEntries;
    }

    /**
     * Iterates on classes tagged with 'dedi_megamenu_entry' and adds them to the Entry discriminator map
     */
    public function loadClassMetadata(LoadClassMetadataEventArgs $eventArgs): void
    {
        if ($eventArgs->getClassMetadata()->getName() === Entry::class) {
            foreach ($this->menuEntries as $menuEntry) {
                if (!$menuEntry instanceof Entry) {
                    throw new LogicException(sprintf(
                        'Expected object extension of type "%s", got "%s"',
                        Entry::class,
                        get_class($menuEntry),
                    ));
                }
                $classMetadata = $eventArgs->getClassMetadata();
                if (!in_array($menuEntry::class, $classMetadata->discriminatorMap, true)) {
                    $classMetadata->setDiscriminatorMap([$menuEntry->getType() => $menuEntry::class]);
                }
            }
        }
    }
}
