<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Entity;

use Dedi\SyliusMegamenuPlugin\Enum\EntryTypes;
use Dedi\SyliusMegamenuPlugin\Form\Listener\AdAwareInterface;
use Sylius\Component\Core\Model\TaxonInterface;
use Sylius\Component\Resource\Model\TranslationInterface;

class TaxonCatalogEntry extends Entry implements TaxonCatalogEntryInterface
{
    public function getType(): string
    {
        return EntryTypes::TAXON_CATALOG;
    }

    protected function createTranslation(): TranslationInterface
    {
        return new TaxonCatalogEntryTranslation();
    }

    public function getTaxon(): ?TaxonInterface
    {
        /** @var TaxonCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getTaxon();
    }

    public function setTaxon(?TaxonInterface $taxon): TaxonCatalogEntryInterface
    {
        /** @var TaxonCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();
        $translation->setTaxon($taxon);

        return $this;
    }

    public function getAdImage(): ?string
    {
        /** @var TaxonCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getAdImage();
    }

    public function setAdImage(?string $adImage): AdAwareInterface
    {
        /** @var TaxonCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();
        $translation->setAdImage($adImage);

        return $this;
    }

    public function getAdUrl(): ?string
    {
        /** @var TaxonCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getAdUrl();
    }

    public function setAdUrl(?string $adUrl): AdAwareInterface
    {
        /** @var TaxonCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();
        $translation->setAdUrl($adUrl);

        return $this;
    }
}
