<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Entity;

use Dedi\SyliusMegamenuPlugin\Form\Listener\AdAwareInterface;
use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Model\TaxonInterface;
use Sylius\Component\Resource\Model\TranslationInterface;

interface ProductCatalogEntryTranslationInterface extends EntryTranslationInterface, TranslationInterface, AdAwareInterface
{
    public function getTaxons(): Collection;

    public function getRootTaxons(): Collection;

    public function addTaxon(TaxonInterface $taxon): self;

    public function removeTaxon(TaxonInterface $taxon): self;

    public function hasTaxon(TaxonInterface $taxon): bool;
}
