<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Entity;

use Dedi\SyliusMegamenuPlugin\Enum\EntryTypes;
use Sylius\Component\Resource\Model\TranslationInterface;

class DirectLinkEntry extends Entry implements DirectLinkEntryInterface
{
    /** @var bool */
    protected $opensInNewTab = false;

    public function opensInNewTab(): bool
    {
        return $this->opensInNewTab;
    }

    public function setOpensInNewTab(bool $opensInNewTab): DirectLinkEntryInterface
    {
        $this->opensInNewTab = $opensInNewTab;

        return $this;
    }

    public function getType(): string
    {
        return EntryTypes::DIRECT_LINK;
    }

    protected function createTranslation(): TranslationInterface
    {
        return new DirectLinkEntryTranslation();
    }

    public function getUrl(): ?string
    {
        /** @var DirectLinkEntryTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getUrl();
    }

    public function setUrl(?string $url): DirectLinkEntryInterface
    {
        /** @var DirectLinkEntryTranslationInterface $translation */
        $translation = $this->getTranslation();
        $translation->setUrl($url);

        return $this;
    }

    public function getLabel(): ?string
    {
        /** @var DirectLinkEntryTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getLabel();
    }

    public function setLabel(?string $label): DirectLinkEntryInterface
    {
        /** @var DirectLinkEntryTranslationInterface $translation */
        $translation = $this->getTranslation();
        $translation->setLabel($label);

        return $this;
    }
}
