const path = require('path');
const Encore = require('@symfony/webpack-encore');
const pluginName = 'megamenu';

Encore.reset();

Encore.setOutputPath(`public/build/dedi-plugin/megamenu/shop/`)
    .setPublicPath(`/build/dedi-plugin/megamenu/shop/`)
    .addEntry(`megamenu`, path.resolve(__dirname, `./src/Resources/assets/app.js`))
    .cleanupOutputBeforeBuild()
    .disableSingleRuntimeChunk()
    .enableSourceMaps(!Encore.isProduction())
    .enableSassLoader();

const shopConfig = Encore.getWebpackConfig();
shopConfig.name = `dedi-${pluginName}-shop`;

Encore.reset();

Encore.setOutputPath(`src/Resources/public/build/`)
    .setPublicPath(`/public/build/`)
    .addEntry(`megamenu`, path.resolve(__dirname, `./src/Resources/assets/app.js`))
    .cleanupOutputBeforeBuild()
    .disableSingleRuntimeChunk()
    .enableSassLoader();

const distConfig = Encore.getWebpackConfig();
distConfig.name = `dedi-plugin-dist`;

Encore.reset();

module.exports = [shopConfig, distConfig];
