<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Twig\Component\Menu;

use Dedi\SyliusMegamenuPlugin\Context\MenuContextInterface;
use Doctrine\Common\Collections\Collection;
use Symfony\UX\TwigComponent\Attribute\AsTwigComponent;
use Symfony\UX\TwigComponent\Attribute\ExposeInTemplate;

#[AsTwigComponent]
class MegamenuComponent
{
    public function __construct(private readonly MenuContextInterface $menuContext)
    {
    }

    #[ExposeInTemplate('entries')]
    public function entries(): Collection
    {
        return $this->menuContext->getMenu()->getEnabledEntries();
    }
}
