<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Twig\Component\Form;

use Dedi\SyliusMegamenuPlugin\Entity\EntryInterface;
use Dedi\SyliusMegamenuPlugin\Entity\Menu;
use Dedi\SyliusMegamenuPlugin\Repository\EntryRepositoryInterface;
use Doctrine\Persistence\ObjectManager;
use Sylius\Bundle\UiBundle\Twig\Component\TemplatePropTrait;
use Sylius\TwigHooks\LiveComponent\HookableLiveComponentTrait;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveAction;
use Symfony\UX\LiveComponent\Attribute\LiveArg;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\DefaultActionTrait;

#[AsLiveComponent]
class EntriesComponent
{
    use DefaultActionTrait;
    use HookableLiveComponentTrait;
    use TemplatePropTrait;

    #[LiveProp(fieldName: 'menu')]
    public ?Menu $menu = null;

    public function __construct(
        protected readonly EntryRepositoryInterface $entryRepository,
        protected readonly ObjectManager $entryManager,
    ) {
    }

    public function getEntries(): array
    {
        return $this->menu?->getEntries()->toArray();
    }

    #[LiveAction]
    public function moveUp(#[LiveArg] int $entryId): void
    {
        /** @var EntryInterface|null $entryToBeMoved */
        $entryToBeMoved = $this->entryRepository->find($entryId);

        if (null === $entryToBeMoved) {
            return;
        }

        if ($entryToBeMoved->getPosition() > 0) {
            $entryToBeMoved->setPosition($entryToBeMoved->getPosition() - 1);
            $this->entryManager->flush();
        }
    }

    #[LiveAction]
    public function moveDown(#[LiveArg] int $entryId): void
    {
        /** @var EntryInterface|null $entryToBeMoved */
        $entryToBeMoved = $this->entryRepository->find($entryId);

        if (null === $entryToBeMoved) {
            return;
        }

        $entryToBeMoved->setPosition($entryToBeMoved->getPosition() + 1);
        $this->entryManager->flush();
    }
}
