import { Controller } from '@hotwired/stimulus';

export default class extends Controller {
  connect() {
    this.dediMenu();
    this.overlayMenu();

    window.addEventListener('resize', () => {
      this.dediMenu();
      this.overlayMenu();
    });
  }

  initMegaMenu(listCategories) {
    const menuLvl1 = listCategories.closest('.has-submenu');

    // Sélection du premier sous-menu
    listCategories.children[0].classList.add('active');

    // Vérification de la hauteur du premier sous-menu
    // besoin d'afficher temporairement le bloc le temps de récupérer sa hauteur
    menuLvl1.querySelector('.menu-block').style.display = 'block';
    const submenuHeight = listCategories.querySelector('.menu-block-wrapper').clientHeight;
    menuLvl1.querySelector('.menu-block').style.display = '';
    // eslint-disable-next-line no-param-reassign
    listCategories.style.minHeight = `${submenuHeight}px`;
  }

  dediMenu() {
    // Déclaration des variables
    const header = document.querySelector('.header-container');
    const menu = document.querySelector('.menu-container');
    const pictoMenu = document.querySelectorAll('.header-link-menu');
    const bodyPage = document.body;
    const submenuTrigger = document.querySelectorAll('.has-submenu > .menu-title');
    const backMenu = document.querySelectorAll('.menu-back');
    const blockMenu = document.querySelectorAll('.menu-block');

    const userAgent = navigator.userAgent.toLowerCase();
    const isTablet = /(ipad|tablet|(android(?!.*mobile))|(windows(?!.*phone)(.*touch))|kindle|playbook|silk|(puffin(?!.*(IP|AP|WP))))/.test(userAgent);

    if (!pictoMenu || !menu) {
      return;
    }

    /**
     * @description
     * Récupération de la taille du header
     */
    if (window.matchMedia('(max-width: 991px)').matches) {
      menu.style.top = `${header.clientHeight}px`;
    } else {
      menu.style.top = '';
    }

    /**
     * @description
     * Ouverture/Fermeture lors du clic sur le picto menu
     */
    // eslint-disable-next-line no-restricted-syntax
    for (const picto of pictoMenu) {
      // eslint-disable-next-line func-names
      picto.onclick = function (e) {
        e.preventDefault();
        bodyPage.classList.toggle('open-menu');
        if (!bodyPage.classList.contains('open-menu')) {
          // eslint-disable-next-line no-restricted-syntax
          for (const item of blockMenu) {
            item.classList.remove('open');
          }
        }
      };
    }

    /**
     * @description
     * Si mobile : Detection du click pour ouvrir le menu suivant et affectation de la classe open
     * Si tablette : On ouvre le menu au clic et on affiche un lien "Voir tout"
     */
    // eslint-disable-next-line no-restricted-syntax
    for (const item of submenuTrigger) {
      const seeAllSection = item.nextElementSibling.querySelector('.menu-see-all-tablet');
      if (seeAllSection) {
        if (window.matchMedia('(min-width: 992px)').matches && isTablet) {
          menu.classList.add('menu-tablet');
        } else {
          menu.classList.remove('menu-tablet');
        }
      }

      // eslint-disable-next-line func-names
      item.onclick = function (e) {
        if (window.matchMedia('(max-width: 991px)').matches) {
          e.preventDefault();
          this.nextElementSibling.classList.add('open');
        } else if (isTablet) {
          e.preventDefault();
        }
      };
    }

    /**
     * @description
     * Detection du click pour le retour arrière et suppression de la classe open
     */
    // eslint-disable-next-line no-restricted-syntax
    for (const item of backMenu) {
      // eslint-disable-next-line func-names
      item.onclick = function (e) {
        e.preventDefault();
        this.closest('.menu-block').classList.remove('open');
      };
    }

    const that = this;

    /**
     * @description
     * Cas spécifique : menu groupé pour menu desktop
     */
    if (window.matchMedia('(min-width: 992px)').matches) {
      const menuGroups = document.querySelectorAll('.menu-group');
      // eslint-disable-next-line no-restricted-syntax
      for (const group of menuGroups) {
        const categories = group.children;

        // Init menu
        this.initMegaMenu(group);

        // eslint-disable-next-line no-restricted-syntax
        for (const category of categories) {
          // eslint-disable-next-line func-names
          category.onmouseenter = function () {
            // Désactivation des autres menus
            group.querySelector('.active').classList.remove('active');

            // Activation du menu survolé
            this.classList.add('active');

            // Modification de la hauteur du fond du menu
            const submenuHeight = this.querySelector('.menu-block-wrapper').clientHeight;
            group.style.minHeight = `${submenuHeight}px`;
          };
          // eslint-disable-next-line func-names
          category.onmouseleave = function () {
            // Désactivation du menu
            this.classList.remove('active');

            // Reinit menu : Si plus aucun menu survolé, on affiche le premier de la liste
            if (group.querySelectorAll('.active').length === 0) {
              that.initMegaMenu(group);
            }
          };
        }
      }
    }
  }

  /**
   * @description
   * Overlay lors de l'ouverture du menu desktop
   */
  overlayMenu() {
    const target = document.querySelector('body');

    // Init
    target.classList.remove('menu-mask');

    if (window.matchMedia('(min-width: 992px)').matches) {
      const firstLi = document.querySelectorAll('.menu-lvl1 > li');

      // eslint-disable-next-line no-restricted-syntax
      for (const item of firstLi) {
        // eslint-disable-next-line func-names
        item.onmouseenter = function () {
          if (this.classList.contains('has-submenu')) {
            target.classList.add('menu-mask');
          } else {
            target.classList.remove('menu-mask');
          }
        };
        // eslint-disable-next-line func-names
        item.onmouseleave = function () {
          target.classList.remove('menu-mask');
        };
      }
    }
  }
}
