<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Menu;

use Knp\Menu\ItemInterface;
use Sylius\Bundle\UiBundle\Menu\Event\MenuBuilderEvent;

final class AdminMenuListener
{
    public function addAdminMenuItems(MenuBuilderEvent $event): void
    {
        $menu = $event->getMenu();

        $configuration = $menu->getChild('configuration');

        if (null !== $configuration) {
            $configuration
                ->addChild('dedi_megamenu_menu', ['route' => 'dedi_megamenu_admin_menu_index'])
                ->setLabel('dedi_megamenu.ui.manage_menu')
                ->setLabelAttribute('icon', 'sitemap')
            ;

            $this->reorderChildren($configuration);
        }
    }

    /**
     * Tries to put dedi_megamenu_menu after channels
     */
    private function reorderChildren(ItemInterface $configuration): void
    {
        $order = array_map(fn (ItemInterface $item): string => $item->getName(), $configuration->getChildren());

        unset($order['dedi_megamenu_menu']);

        $newOrder = [];
        foreach ($order as $k => $v) {
            $newOrder[$k] = $v;

            if ($k === 'channels') {
                $newOrder['dedi_megamenu_menu'] = 'dedi_megamenu_menu';
            }
        }

        if (!array_key_exists('dedi_megamenu_menu', $newOrder)) {
            $newOrder['dedi_megamenu_menu'] = 'dedi_megamenu_menu';
        }

        $configuration->reorderChildren($newOrder);
    }
}
