<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Form\Type;

use Sylius\Bundle\AdminBundle\Form\Type\TaxonAutocompleteType;
use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotNull;

final class TaxonCatalogEntryTranslationType extends AbstractResourceType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('taxon', TaxonAutocompleteType::class, [
                'multiple' => false,
                'constraints' => [
                    new NotNull(['groups' => ['default', 'sylius']]),
                ],
            ])
            ->add('ad', AdType::class, [
                'data_class' => $this->dataClass,
            ])
        ;
    }

    public function getParent()
    {
        return EntryTranslationType::class;
    }
}
