<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Form\Type;

use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Sylius\Bundle\TaxonomyBundle\Form\Type\TaxonAutocompleteChoiceType;
use Symfony\Component\Form\FormBuilderInterface;

final class ProductCatalogEntryTranslationType extends AbstractResourceType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('taxons', TaxonAutocompleteChoiceType::class, [
                'label' => 'sylius.ui.taxons',
                'multiple' => true,
            ])
            ->add('ad', AdType::class, [
                'data_class' => $this->dataClass,
            ])
        ;
    }

    public function getParent()
    {
        return EntryTranslationType::class;
    }
}
