<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Form\Type;

use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\FormBuilderInterface;

final class EntryPositionType extends AbstractResourceType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('position', IntegerType::class, [
                'label' => 'sylius.form.taxon.position',
            ])
        ;
    }

    public function getBlockPrefix(): string
    {
        return 'dedi_megamenu_entry_position';
    }
}
