<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Form\Type;

use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Sylius\Bundle\ResourceBundle\Form\Type\ResourceTranslationsType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\FormBuilderInterface;

final class DirectLinkEntryType extends AbstractResourceType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('opensInNewTab', CheckboxType::class, [
                'required' => false,
                'label' => 'dedi_megamenu.ui.opens_in_new_tab',
            ])
            ->add('translations', ResourceTranslationsType::class, [
                'entry_type' => DirectLinkEntryTranslationType::class,
            ])
        ;
    }

    public function getParent(): string
    {
        return EntryType::class;
    }
}
