<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Form\Type;

use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotNull;

final class DirectLinkEntryTranslationType extends AbstractResourceType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('url', UrlType::class, [
                'label' => 'dedi_megamenu.ui.url',
                'constraints' => [
                    new NotNull(['groups' => ['default', 'sylius']]),
                ],
            ])
        ;
    }

    public function getParent()
    {
        return EntryTranslationType::class;
    }
}
