<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Form\Listener;

use LogicException;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\String\Slugger\SluggerInterface;

final class AdFileUploader implements AdFileUploaderInterface
{
    private readonly string $publicPath;

    private readonly string $imagePath;

    private readonly SluggerInterface $slugger;

    public function __construct(
        string $publicPath,
        string $imagePath,
        SluggerInterface $slugger,
    ) {
        $this->slugger = $slugger;
        $this->publicPath = $publicPath;
        $this->imagePath = $imagePath;
    }

    public function handleFileUpload(FormEvent $event): void
    {
        $fileAware = $event->getForm()->getData();
        if (null === $fileAware) {
            return;
        }

        if (!$fileAware instanceof AdAwareInterface) {
            throw new LogicException(sprintf(
                'Expected object of type "%s", got "%s"',
                AdAwareInterface::class,
                get_class($fileAware),
            ));
        }

        if ($event->getForm()->get('removeFile')->getData() === true) {
            $fileAware->setAdImage(null);

            return;
        }

        $file = $event->getForm()->get('file')->getData();
        if (null === $file) {
            return;
        }

        $originalFilename = pathinfo($file->getClientOriginalName(), \PATHINFO_FILENAME);
        $safeFilename = $this->slugger->slug($originalFilename);
        $newFilename = sprintf('%s-%s.%s', $safeFilename, uniqid(), $file->guessExtension());

        $file->move(sprintf('%s/%s', $this->publicPath, $this->imagePath), $newFilename);
        $fileAware->setAdImage(sprintf('/%s/%s', $this->imagePath, $newFilename));
    }
}
