<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Factory;

use Dedi\SyliusMegamenuPlugin\Entity\EntryInterface;
use Dedi\SyliusMegamenuPlugin\Entity\MenuInterface;

abstract class AbstractSpecializedEntryFactory implements SpecializedEntryFactoryInterface
{
    public function createForMenu(MenuInterface $menu): EntryInterface
    {
        $entry = $this->createNew();
        $entry->setMenu($menu);

        return $entry;
    }
}
