<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\EventListener;

use Dedi\SyliusMegamenuPlugin\Entity\MenuInterface;
use Doctrine\ORM\EntityManagerInterface;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Resource\Factory\FactoryInterface;
use Symfony\Component\EventDispatcher\GenericEvent;

final class ChannelMenuAssignerListener implements ChannelMenuAssignerListenerInterface
{
    private readonly FactoryInterface $menuFactory;

    private readonly EntityManagerInterface $em;

    public function __construct(
        FactoryInterface $menuFactory,
        EntityManagerInterface $em,
    ) {
        $this->menuFactory = $menuFactory;
        $this->em = $em;
    }

    public function onChannelPreCreate(GenericEvent $event): void
    {
        $subject = $event->getSubject();
        if (!$subject instanceof ChannelInterface) {
            return;
        }

        /** @var MenuInterface $menu */
        $menu = $this->menuFactory->createNew();
        $menu->setChannel($subject);

        $this->em->persist($menu);
    }
}
