<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Entity;

use Dedi\SyliusMegamenuPlugin\Form\Listener\AdAwareInterface;
use Sylius\Component\Core\Model\TaxonInterface;

class TaxonCatalogEntryTranslation extends EntryTranslation implements TaxonCatalogEntryTranslationInterface
{
    /** @var TaxonInterface|null */
    protected $taxon;

    /** @var string|null */
    protected $adImage;

    /** @var string|null */
    protected $adUrl;

    public function getTaxon(): ?TaxonInterface
    {
        return $this->taxon;
    }

    public function setTaxon(?TaxonInterface $taxon): TaxonCatalogEntryTranslationInterface
    {
        $this->taxon = $taxon;

        return $this;
    }

    public function getAdImage(): ?string
    {
        return $this->adImage;
    }

    public function setAdImage(?string $adImage): AdAwareInterface
    {
        $this->adImage = $adImage;

        return $this;
    }

    public function getAdUrl(): ?string
    {
        return $this->adUrl;
    }

    public function setAdUrl(?string $adUrl): AdAwareInterface
    {
        $this->adUrl = $adUrl;

        return $this;
    }
}
