<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Entity;

use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Model\ChannelInterface;
use Sylius\Component\Resource\Model\ResourceInterface;

interface MenuInterface extends ResourceInterface
{
    public function getName(): ?string;

    public function getChannel(): ChannelInterface;

    public function setChannel(ChannelInterface $channel): self;

    public function getEntries(): Collection;

    public function getEnabledEntries(): Collection;

    public function addEntry(EntryInterface $entry): self;

    public function removeEntry(EntryInterface $entry): self;

    public function hasEntry(EntryInterface $entry): bool;
}
