<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Entity;

use Sylius\Component\Resource\Model\AbstractTranslation;

abstract class EntryTranslation extends AbstractTranslation implements EntryTranslationInterface
{
    /** @var mixed|null */
    protected $id;

    /** @var string|null */
    protected $name;

    /** @var string|null */
    protected $icon;

    /**
     * @return mixed|null
     */
    public function getId()
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): EntryTranslationInterface
    {
        $this->name = $name;

        return $this;
    }

    public function getIcon(): ?string
    {
        return $this->icon;
    }

    public function setIcon(?string $icon): EntryTranslationInterface
    {
        $this->icon = $icon;

        return $this;
    }
}
