<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\DependencyInjection;

use Dedi\SyliusMegamenuPlugin\Controller\EntryController;
use Dedi\SyliusMegamenuPlugin\Entity\DirectLinkEntry;
use Dedi\SyliusMegamenuPlugin\Entity\DirectLinkEntryInterface;
use Dedi\SyliusMegamenuPlugin\Entity\DirectLinkEntryTranslation;
use Dedi\SyliusMegamenuPlugin\Entity\DirectLinkEntryTranslationInterface;
use Dedi\SyliusMegamenuPlugin\Entity\Entry;
use Dedi\SyliusMegamenuPlugin\Entity\EntryInterface;
use Dedi\SyliusMegamenuPlugin\Entity\Menu;
use Dedi\SyliusMegamenuPlugin\Entity\MenuInterface;
use Dedi\SyliusMegamenuPlugin\Entity\ProductCatalogEntry;
use Dedi\SyliusMegamenuPlugin\Entity\ProductCatalogEntryInterface;
use Dedi\SyliusMegamenuPlugin\Entity\ProductCatalogEntryTranslation;
use Dedi\SyliusMegamenuPlugin\Entity\ProductCatalogEntryTranslationInterface;
use Dedi\SyliusMegamenuPlugin\Entity\TaxonCatalogEntry;
use Dedi\SyliusMegamenuPlugin\Entity\TaxonCatalogEntryInterface;
use Dedi\SyliusMegamenuPlugin\Entity\TaxonCatalogEntryTranslation;
use Dedi\SyliusMegamenuPlugin\Entity\TaxonCatalogEntryTranslationInterface;
use Dedi\SyliusMegamenuPlugin\Factory\DirectLinkEntryFactory;
use Dedi\SyliusMegamenuPlugin\Factory\ProductCatalogEntryFactory;
use Dedi\SyliusMegamenuPlugin\Factory\TaxonCatalogEntryFactory;
use Dedi\SyliusMegamenuPlugin\Form\Type\Admin\DirectLinkEntryType;
use Dedi\SyliusMegamenuPlugin\Form\Type\Admin\ProductCatalogEntryType;
use Dedi\SyliusMegamenuPlugin\Form\Type\Admin\TaxonCatalogEntryType;
use Dedi\SyliusMegamenuPlugin\Form\Type\DirectLinkEntryTranslationType;
use Dedi\SyliusMegamenuPlugin\Form\Type\ProductCatalogEntryTranslationType;
use Dedi\SyliusMegamenuPlugin\Form\Type\TaxonCatalogEntryTranslationType;
use Dedi\SyliusMegamenuPlugin\Repository\DirectLinkEntryRepository;
use Dedi\SyliusMegamenuPlugin\Repository\EntryRepository;
use Dedi\SyliusMegamenuPlugin\Repository\MenuRepository;
use Dedi\SyliusMegamenuPlugin\Repository\ProductCatalogEntryRepository;
use Dedi\SyliusMegamenuPlugin\Repository\TaxonCatalogEntryRepository;
use Sylius\Bundle\ResourceBundle\Controller\ResourceController;
use Sylius\Bundle\ResourceBundle\Doctrine\ORM\EntityRepository;
use Sylius\Bundle\ResourceBundle\Form\Type\DefaultResourceType;
use Sylius\Bundle\ResourceBundle\SyliusResourceBundle;
use Sylius\Component\Resource\Factory\Factory;
use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('dedi_sylius_megamenu');
        /** @var ArrayNodeDefinition $rootNode */
        $rootNode = $treeBuilder->getRootNode();

        $rootNode
            ->addDefaultsIfNotSet()
            ->children()
                ->scalarNode('driver')->defaultValue(SyliusResourceBundle::DRIVER_DOCTRINE_ORM)->end()
            ->end()
        ;

        $this->addResourcesSection($rootNode);

        return $treeBuilder;
    }

    private function addResourcesSection(ArrayNodeDefinition $node): void
    {
        $node
            ->children()
                ->arrayNode('resources')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->arrayNode('menu')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->variableNode('options')->end()
                                ->arrayNode('classes')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(Menu::class)->cannotBeEmpty()->end()
                                        ->scalarNode('interface')->defaultValue(MenuInterface::class)->cannotBeEmpty()->end()
                                        ->scalarNode('controller')->defaultValue(ResourceController::class)->end()
                                        ->scalarNode('repository')->defaultValue(MenuRepository::class)->end()
                                        ->scalarNode('factory')->defaultValue(Factory::class)->end()
                                        ->scalarNode('form')->defaultValue(DefaultResourceType::class)->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('entry')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->variableNode('options')->end()
                                ->arrayNode('classes')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(Entry::class)->cannotBeEmpty()->end()
                                        ->scalarNode('interface')->defaultValue(EntryInterface::class)->cannotBeEmpty()->end()
                                        ->scalarNode('controller')->defaultValue(EntryController::class)->end()
                                        ->scalarNode('repository')->defaultValue(EntryRepository::class)->end()
                                        ->scalarNode('factory')->defaultValue(Factory::class)->end()
                                        ->scalarNode('form')->defaultValue(DefaultResourceType::class)->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('direct_link_entry')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->variableNode('options')->end()
                                ->arrayNode('classes')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(DirectLinkEntry::class)->cannotBeEmpty()->end()
                                        ->scalarNode('interface')->defaultValue(DirectLinkEntryInterface::class)->cannotBeEmpty()->end()
                                        ->scalarNode('controller')->defaultValue(ResourceController::class)->end()
                                        ->scalarNode('repository')->defaultValue(DirectLinkEntryRepository::class)->end()
                                        ->scalarNode('factory')->defaultValue(DirectLinkEntryFactory::class)->end()
                                        ->scalarNode('form')->defaultValue(DirectLinkEntryType::class)->end()
                                    ->end()
                                ->end()
                                ->arrayNode('translation')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->variableNode('options')->end()
                                        ->arrayNode('classes')
                                            ->addDefaultsIfNotSet()
                                            ->children()
                                                ->scalarNode('model')->defaultValue(DirectLinkEntryTranslation::class)->cannotBeEmpty()->end()
                                                ->scalarNode('interface')->defaultValue(DirectLinkEntryTranslationInterface::class)->cannotBeEmpty()->end()
                                                ->scalarNode('controller')->defaultValue(ResourceController::class)->cannotBeEmpty()->end()
                                                ->scalarNode('repository')->defaultValue(EntityRepository::class)->cannotBeEmpty()->end()
                                                ->scalarNode('factory')->defaultValue(Factory::class)->end()
                                                ->scalarNode('form')->defaultValue(DirectLinkEntryTranslationType::class)->cannotBeEmpty()->end()
                                            ->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('product_catalog_entry')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->variableNode('options')->end()
                                ->arrayNode('classes')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(ProductCatalogEntry::class)->cannotBeEmpty()->end()
                                        ->scalarNode('interface')->defaultValue(ProductCatalogEntryInterface::class)->cannotBeEmpty()->end()
                                        ->scalarNode('controller')->defaultValue(ResourceController::class)->end()
                                        ->scalarNode('repository')->defaultValue(ProductCatalogEntryRepository::class)->end()
                                        ->scalarNode('factory')->defaultValue(ProductCatalogEntryFactory::class)->end()
                                        ->scalarNode('form')->defaultValue(ProductCatalogEntryType::class)->end()
                                    ->end()
                                ->end()
                                ->arrayNode('translation')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->variableNode('options')->end()
                                        ->arrayNode('classes')
                                            ->addDefaultsIfNotSet()
                                            ->children()
                                                ->scalarNode('model')->defaultValue(ProductCatalogEntryTranslation::class)->cannotBeEmpty()->end()
                                                ->scalarNode('interface')->defaultValue(ProductCatalogEntryTranslationInterface::class)->cannotBeEmpty()->end()
                                                ->scalarNode('controller')->defaultValue(ResourceController::class)->cannotBeEmpty()->end()
                                                ->scalarNode('repository')->defaultValue(EntityRepository::class)->cannotBeEmpty()->end()
                                                ->scalarNode('factory')->defaultValue(Factory::class)->end()
                                                ->scalarNode('form')->defaultValue(ProductCatalogEntryTranslationType::class)->cannotBeEmpty()->end()
                                            ->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                        ->arrayNode('taxon_catalog_entry')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->variableNode('options')->end()
                                ->arrayNode('classes')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(TaxonCatalogEntry::class)->cannotBeEmpty()->end()
                                        ->scalarNode('interface')->defaultValue(TaxonCatalogEntryInterface::class)->cannotBeEmpty()->end()
                                        ->scalarNode('controller')->defaultValue(ResourceController::class)->end()
                                        ->scalarNode('repository')->defaultValue(TaxonCatalogEntryRepository::class)->end()
                                        ->scalarNode('factory')->defaultValue(TaxonCatalogEntryFactory::class)->end()
                                        ->scalarNode('form')->defaultValue(TaxonCatalogEntryType::class)->end()
                                    ->end()
                                ->end()
                                ->arrayNode('translation')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->variableNode('options')->end()
                                        ->arrayNode('classes')
                                            ->addDefaultsIfNotSet()
                                            ->children()
                                                ->scalarNode('model')->defaultValue(TaxonCatalogEntryTranslation::class)->cannotBeEmpty()->end()
                                                ->scalarNode('interface')->defaultValue(TaxonCatalogEntryTranslationInterface::class)->cannotBeEmpty()->end()
                                                ->scalarNode('controller')->defaultValue(ResourceController::class)->cannotBeEmpty()->end()
                                                ->scalarNode('repository')->defaultValue(EntityRepository::class)->cannotBeEmpty()->end()
                                                ->scalarNode('factory')->defaultValue(Factory::class)->end()
                                                ->scalarNode('form')->defaultValue(TaxonCatalogEntryTranslationType::class)->cannotBeEmpty()->end()
                                            ->end()
                                        ->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;
    }
}
