<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\DataFixtures\Fixture;

use Doctrine\Persistence\ObjectManager;
use Sylius\Bundle\CoreBundle\Fixture\Factory\ExampleFactoryInterface;
use Sylius\Bundle\FixturesBundle\Fixture\FixtureInterface;
use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;

class MegamenuFixture implements FixtureInterface
{
    public function __construct(
        private readonly ObjectManager $objectManager,
        private readonly ExampleFactoryInterface $menuFactory,
        private readonly ExampleFactoryInterface $entryFactory,
    ) {
    }

    public function getName(): string
    {
        return 'megamenu';
    }

    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder($this->getName());

        /** @var ArrayNodeDefinition $optionsNode */
        $optionsNode = $treeBuilder->getRootNode();

        // @phpstan-ignore-next-line
        $optionsNode
            ->children()
                ->arrayNode('menu')
                    ->prototype('array')
                        ->children()
                            ->scalarNode('channel')->cannotBeEmpty()->end()
                            ->arrayNode('items')
                                ->prototype('array')
                                    ->children()
                                        ->scalarNode('type')->cannotBeEmpty()->end()
                                        ->scalarNode('name')->cannotBeEmpty()->end()
                                        ->integerNode('position')->end()
                                        ->scalarNode('icon')->defaultNull()->end()
                                        ->scalarNode('url')->defaultNull()->end()
                                        ->scalarNode('label')->defaultNull()->end()
                                        ->scalarNode('taxon')->defaultNull()->end()
                                        ->arrayNode('taxons')->scalarPrototype()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
        ;

        return $treeBuilder;
    }

    public function load(array $options): void
    {
        foreach ($options['menu'] as $menuOptions) {
            $megamenu = $this->menuFactory->create($menuOptions);
            $this->objectManager->persist($megamenu);
            $this->objectManager->flush();

            foreach ($menuOptions['items'] as $entryOptions) {
                $entryOptions['menu'] = $megamenu;
                $entry = $this->entryFactory->create($entryOptions);
                $this->objectManager->persist($entry);
                $this->objectManager->flush();
            }
        }
    }
}
