<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\DataFixtures\Factory;

use Dedi\SyliusMegamenuPlugin\Entity\MenuInterface;
use Dedi\SyliusMegamenuPlugin\Repository\MenuRepositoryInterface;
use Sylius\Bundle\CoreBundle\Fixture\Factory\ExampleFactoryInterface;
use Sylius\Component\Channel\Repository\ChannelRepositoryInterface;
use Sylius\Component\Resource\Factory\FactoryInterface;

class MegamenuFactory implements ExampleFactoryInterface
{
    public function __construct(
        private readonly MenuRepositoryInterface $menuRepository,
        private readonly ChannelRepositoryInterface $channelRepository,
        private readonly FactoryInterface $menuFactory,
    ) {
    }

    public function create(array $options = []): MenuInterface
    {
        $channel = $this->channelRepository->findOneBy(['code' => $options['channel']]);

        /** @var MenuInterface|null $menu */
        $menu = $this->menuRepository->findOneBy(['channel' => $channel]);

        if (null === $menu) {
            /** @var MenuInterface $menu */
            $menu = $this->menuFactory->createNew();
            $menu->setChannel($channel);
        }

        return $menu;
    }
}
