# Installation

Run `composer require require dedi/sylius-megamenu-plugin`

Add plugin class to your `config/bundles.php`:

```php
<?php
$bundles = [
    // ...
    Dedi\SyliusMegamenuPlugin\DediSyliusMegamenuPlugin::class => ['all' => true],
    // ...
];
```

# Basic Configuration

## Import the plugin configuration

```yaml
# config/packages/dedi_sylius_megamenu.yaml

imports:
    - { resource: "@DediSyliusMegamenuPlugin/Resources/config/config.yml" }

```

## Import routing

```yaml
# config/routes.yaml

dedi_sylius_megamenu_shop:
    resource: "@DediSyliusMegamenuPlugin/Resources/config/shop_routing.yml"
    prefix: /{_locale}
    requirements:
        _locale: ^[a-z]{2}(?:_[A-Z]{2})?$

dedi_sylius_megamenu_admin:
    resource: "@DediSyliusMegamenuPlugin/Resources/config/admin_routing.yml"
    prefix: /admin
```

## Extend your `TaxonRepository`

```php
<?php

use Dedi\SyliusMegamenuPlugin\Repository\Taxon\TaxonRepositoryInterface;
use Dedi\SyliusMegamenuPlugin\Repository\Taxon\TaxonRepositoryTrait;
use Sylius\Bundle\TaxonomyBundle\Doctrine\ORM\TaxonRepository as BaseTaxonRepository;

class TaxonRepository extends BaseTaxonRepository implements TaxonRepositoryInterface
{
    use TaxonRepositoryTrait;
}
```

## Add configuration

```yaml
# config/packages/_sylius.yaml

sylius_taxonomy:
    resources:
        taxon:
            classes:
                repository: App\Repository\TaxonRepository
```

## Create migration

Create migration with `bin/console doctrine:migration:diff`

Manually create this migration (after the one previously generated)

```php
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        $this->addSql('INSERT INTO dedi_megamenu_plugin_menu (channel_id) SELECT id FROM sylius_channel');
    }

    public function down(Schema $schema): void
    {
        $this->addSql('DELETE FROM dedi_megamenu_plugin_menu WHERE channel_id IN (SELECT id FROM sylius_channel)');
    }
```

# Additional notes

Check out the [concepts documentation](CONCEPTS.md) for more in depth information on this plugin. 
