const openedLevel = 0;

const trees = document.querySelectorAll('[data-simple-tree-selector]');

trees.forEach((tree) => {
    const items = tree.querySelectorAll('[data-item]');

    items.forEach((item) => {
        const list = item.querySelector(`[data-list="${item.dataset.listTarget}"]`);
        const label = item.querySelector(`[data-label="${item.dataset.labelTarget}"]`);
        const icon = item.querySelector(`[data-icon="${item.dataset.iconTarget}"]`);
        const input = item.querySelector(`[name="${item.dataset.inputName}"]`);

        const level = parseInt(item.dataset.level);

        if (list === null) {
            return;

        }

        // initialize opened items
        if (level > openedLevel) {
            list.style.display = 'none';
        } else if (level === openedLevel ) {
            icon.classList.add('open');
        }

        // toggle list on click
        label.addEventListener('click', () => {
            if (list.style.display === 'none') {
                icon.classList.add('open');
            } else {
                icon.classList.remove('open');
            }

            list.style.display = list.style.display === 'none' ? 'block' : 'none';
        });

        // update child input values when parent is updated
        input.addEventListener('change', () => {
            list.querySelectorAll('input').forEach((childInput) => {
                childInput.checked = input.checked;
            });
        });
    });
});
