
const menus = document.querySelectorAll('[data-menu]');

const closeTab = ({
                      menu,
                      item,
                  }) => {
    item.classList.remove('active');

    const tab = menu.querySelector(`.tab[data-tab="${item.dataset.tab}"]`);
    if (!tab) {
        return;
    }

    tab.classList.remove('active');
};

menus.forEach((menu) => {
    const items = menu.querySelectorAll('.menu[data-items] .item');

    items.forEach((item) => {
        item.addEventListener('click', (e) => {
            if (!item.classList.contains('active')) {
                return;
            }

            e.stopImmediatePropagation();

            closeTab({menu, item});
        });
    })
});

document.addEventListener('click', (e) => {
    for (let i = 0; i < menus.length; i++) {
        const menu = menus[i];

        if (menu.contains(e.target)) {
            return;
        }
    }

    menus.forEach((menu) => {
        const item = menu.querySelector('.menu[data-items] .item.active');
        if (!item) {
            return;
        }

        closeTab({menu, item});
    });
});
