<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Form\Type;

use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Sylius\Bundle\ResourceBundle\Form\Type\ResourceTranslationsType;
use Symfony\Component\Form\FormBuilderInterface;

final class TaxonCatalogEntryType extends AbstractResourceType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('translations', ResourceTranslationsType::class, [
                'entry_type' => TaxonCatalogEntryTranslationType::class,
            ])
        ;
    }

    public function getParent(): string
    {
        return EntryType::class;
    }
}
