<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Form\Type;

use Dedi\SyliusMegamenuPlugin\Repository\Taxon\TaxonRepositoryInterface;
use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotNull;

final class TaxonCatalogEntryTranslationType extends AbstractResourceType
{
    private readonly string $taxonDataClass;

    public function __construct(
        string $dataClass,
        array $validationGroups,
        string $taxonDataClass,
    ) {
        parent::__construct($dataClass, $validationGroups);

        $this->taxonDataClass = $taxonDataClass;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('taxon', EntityType::class, [
                'class' => $this->taxonDataClass,
                'query_builder' => fn (TaxonRepositoryInterface $taxonRepository) => $taxonRepository->createFindFirstLevelQueryBuilder(),
                'constraints' => [
                    new NotNull(['groups' => ['default', 'sylius']]),
                ],
            ])
            ->add('ad', AdType::class, [
                'data_class' => $this->dataClass,
            ])
        ;
    }

    public function getParent()
    {
        return EntryTranslationType::class;
    }
}
