<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Form\Type;

use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\FormBuilderInterface;

final class ProductCatalogEntryTranslationType extends AbstractResourceType
{
    private readonly string $taxonDataClass;

    public function __construct(
        string $dataClass,
        array $validationGroups,
        string $taxonDataClass,
    ) {
        parent::__construct($dataClass, $validationGroups);

        $this->taxonDataClass = $taxonDataClass;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('taxons', EntityType::class, [
                'label' => 'sylius.ui.taxons',
                'class' => $this->taxonDataClass,
                'multiple' => true,
                'expanded' => true,
                'required' => false,
            ])
            ->add('ad', AdType::class, [
                'data_class' => $this->dataClass,
            ])
        ;
    }

    public function getParent()
    {
        return EntryTranslationType::class;
    }
}
