<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Entity;

use Dedi\SyliusMegamenuPlugin\Form\Listener\AdAwareInterface;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Model\TaxonInterface;

class ProductCatalogEntryTranslation extends EntryTranslation implements ProductCatalogEntryTranslationInterface
{
    /**
     * @var Collection|TaxonInterface[]
     * @psalm-var Collection<array-key, TaxonInterface>
     */
    protected $taxons;

    /** @var string|null */
    protected $adImage;

    /** @var string|null */
    protected $adUrl;

    public function __construct()
    {
        $this->taxons = new ArrayCollection();
    }

    public function getTaxons(): Collection
    {
        return $this->taxons;
    }

    public function getRootTaxons(): Collection
    {
        $minTreeLevel = \INF;
        foreach ($this->taxons as $taxon) {
            if ($taxon->getLevel() < $minTreeLevel) {
                $minTreeLevel = $taxon->getLevel();
            }
        }

        return $this->taxons->filter(static fn (TaxonInterface $taxon): bool => $taxon->getLevel() === $minTreeLevel);
    }

    public function addTaxon(TaxonInterface $taxon): ProductCatalogEntryTranslationInterface
    {
        if (!$this->hasTaxon($taxon)) {
            $this->taxons->add($taxon);
        }

        return $this;
    }

    public function removeTaxon(TaxonInterface $taxon): ProductCatalogEntryTranslationInterface
    {
        if ($this->hasTaxon($taxon)) {
            $this->taxons->removeElement($taxon);
        }

        return $this;
    }

    public function hasTaxon(TaxonInterface $taxon): bool
    {
        return $this->taxons->contains($taxon);
    }

    public function getAdImage(): ?string
    {
        return $this->adImage;
    }

    public function setAdImage(?string $adImage): AdAwareInterface
    {
        $this->adImage = $adImage;

        return $this;
    }

    public function getAdUrl(): ?string
    {
        return $this->adUrl;
    }

    public function setAdUrl(?string $adUrl): AdAwareInterface
    {
        $this->adUrl = $adUrl;

        return $this;
    }
}
