<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Entity;

use Dedi\SyliusMegamenuPlugin\Enum\EntryTypes;
use Dedi\SyliusMegamenuPlugin\Form\Listener\AdAwareInterface;
use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Model\TaxonInterface;
use Sylius\Component\Resource\Model\TranslationInterface;

class ProductCatalogEntry extends Entry implements ProductCatalogEntryInterface
{
    public function getType(): string
    {
        return EntryTypes::PRODUCT_CATALOG;
    }

    protected function createTranslation(): TranslationInterface
    {
        return new ProductCatalogEntryTranslation();
    }

    public function getTaxons(): Collection
    {
        /** @var ProductCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getTaxons();
    }

    public function getRootTaxons(): Collection
    {
        /** @var ProductCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getRootTaxons();
    }

    public function addTaxon(TaxonInterface $taxon): ProductCatalogEntryInterface
    {
        /** @var ProductCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();
        $translation->addTaxon($taxon);

        return $this;
    }

    public function removeTaxon(TaxonInterface $taxon): ProductCatalogEntryInterface
    {
        /** @var ProductCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();
        $translation->removeTaxon($taxon);

        return $this;
    }

    public function hasTaxon(TaxonInterface $taxon): bool
    {
        /** @var ProductCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->hasTaxon($taxon);
    }

    public function getAdImage(): ?string
    {
        /** @var ProductCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getAdImage();
    }

    public function setAdImage(?string $adImage): AdAwareInterface
    {
        /** @var ProductCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();
        $translation->setAdImage($adImage);

        return $this;
    }

    public function getAdUrl(): ?string
    {
        /** @var ProductCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getAdUrl();
    }

    public function setAdUrl(?string $adUrl): AdAwareInterface
    {
        /** @var ProductCatalogEntryTranslationInterface $translation */
        $translation = $this->getTranslation();
        $translation->setAdUrl($adUrl);

        return $this;
    }
}
