<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Model\ChannelInterface;

class Menu implements MenuInterface
{
    /** @var mixed|null */
    protected $id;

    /** @var ChannelInterface */
    protected $channel;

    /**
     * @var Collection|EntryInterface[]
     * @psalm-var Collection<array-key, EntryInterface>
     */
    protected $entries;

    public function __construct()
    {
        $this->entries = new ArrayCollection();
    }

    /**
     * @return mixed|null
     */
    public function getId()
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->channel->getName();
    }

    public function getChannel(): ChannelInterface
    {
        return $this->channel;
    }

    public function setChannel(ChannelInterface $channel): MenuInterface
    {
        $this->channel = $channel;

        return $this;
    }

    public function getEntries(): Collection
    {
        return $this->entries;
    }

    public function getEnabledEntries(): Collection
    {
        return $this->entries->filter(fn (EntryInterface $entry): bool => $entry->isEnabled());
    }

    public function addEntry(EntryInterface $entry): MenuInterface
    {
        if (!$this->hasEntry($entry)) {
            $this->entries->add($entry);
        }

        return $this;
    }

    public function removeEntry(EntryInterface $entry): MenuInterface
    {
        if ($this->hasEntry($entry)) {
            $this->entries->removeElement($entry);
        }

        return $this;
    }

    public function hasEntry(EntryInterface $entry): bool
    {
        return $this->entries->contains($entry);
    }
}
