<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Entity;

use Sylius\Component\Resource\Model\CodeAwareInterface;
use Sylius\Component\Resource\Model\ResourceInterface;
use Sylius\Component\Resource\Model\ToggleableInterface;
use Sylius\Component\Resource\Model\TranslatableInterface;

interface EntryInterface extends ResourceInterface, CodeAwareInterface, ToggleableInterface, TranslatableInterface
{
    public function getMenu(): MenuInterface;

    public function setMenu(MenuInterface $menu): self;

    public function getType(): string;

    public function getPosition(): int;

    public function setPosition(int $position): self;

    public function getName(): ?string;

    public function setName(?string $name): self;

    public function getIcon(): ?string;

    public function setIcon(?string $icon): self;
}
