<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Entity;

use Sylius\Component\Resource\Model\ToggleableTrait;
use Sylius\Component\Resource\Model\TranslatableTrait;

abstract class Entry implements EntryInterface
{
    use ToggleableTrait;
    use TranslatableTrait {
        __construct as private initializeTranslationsCollection;
    }

    /** @var mixed|null */
    protected $id;

    /** @var string|null */
    protected $code;

    /** @var MenuInterface */
    protected $menu;

    /** @var int */
    protected $position;

    public function __construct()
    {
        $this->initializeTranslationsCollection();
    }

    /**
     * @return mixed|null
     */
    public function getId()
    {
        return $this->id;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): void
    {
        $this->code = $code;
    }

    public function getMenu(): MenuInterface
    {
        return $this->menu;
    }

    public function setMenu(MenuInterface $menu): EntryInterface
    {
        $this->menu = $menu;

        return $this;
    }

    public function getPosition(): int
    {
        return $this->position;
    }

    public function setPosition(int $position): EntryInterface
    {
        $this->position = $position;

        return $this;
    }

    public function getName(): ?string
    {
        /** @var EntryTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getName();
    }

    public function setName(?string $name): EntryInterface
    {
        /** @var EntryTranslationInterface $translation */
        $translation = $this->getTranslation();
        $translation->setName($name);

        return $this;
    }

    public function getIcon(): ?string
    {
        /** @var EntryTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getIcon();
    }

    public function setIcon(?string $icon): EntryInterface
    {
        /** @var EntryTranslationInterface $translation */
        $translation = $this->getTranslation();
        $translation->setIcon($icon);

        return $this;
    }
}
