<?php

declare(strict_types=1);

namespace Dedi\SyliusMegamenuPlugin\Context;

use Dedi\SyliusMegamenuPlugin\Entity\MenuInterface;
use Dedi\SyliusMegamenuPlugin\Repository\MenuRepositoryInterface;
use Sylius\Component\Channel\Context\ChannelContextInterface;
use Sylius\Component\Core\Model\ChannelInterface;

final class MenuContext implements MenuContextInterface
{
    private readonly ChannelContextInterface $channelContext;

    private readonly MenuRepositoryInterface $menuRepository;

    public function __construct(
        ChannelContextInterface $channelContext,
        MenuRepositoryInterface $menuRepository,
    ) {
        $this->channelContext = $channelContext;
        $this->menuRepository = $menuRepository;
    }

    public function getMenu(): ?MenuInterface
    {
        /** @var ChannelInterface $channel */
        $channel = $this->channelContext->getChannel();

        return $this->menuRepository->findForChannel($channel);
    }
}
