<?php

declare(strict_types=1);

namespace Tests\Dedi\SyliusMarketingPlugin\Application\src\Cart\Twig;

use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use Sylius\Component\Core\Model\ProductVariantInterface;

class AddToCartExtension extends AbstractExtension
{
    public function getVariantOptionsForAddToCart(ProductVariantInterface $productVariant): array
    {
        $options = [];

        $optionValues = $productVariant->getOptionValues();

        foreach ($optionValues as $optionValue) {
            $options[$optionValue->getOptionCode()] = $optionValue->getCode();
        }

        return $options;
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('add_to_cart_variant_options', [$this, 'getVariantOptionsForAddToCart']),
        ];
    }
}
