<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Twig;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Dedi\SyliusMarketingPlugin\DependencyInjection\Settings\SettingsInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;
use Webmozart\Assert\Assert;

class MarketingSettingsExtension extends AbstractExtension
{
    private SettingsProviderInterface $settingsProvider;

    public function __construct(
        SettingsProviderInterface $settingsProvider,
    ) {
        $this->settingsProvider = $settingsProvider;
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('dedi_sylius_marketing_get_setting', [$this, 'getSetting']),
            new TwigFunction('dedi_sylius_marketing_is_enabled', [$this, 'isEnabled']),
        ];
    }

    public function getSetting(string $setting)
    {
        $settings = $this->settingsProvider->provide();

        Assert::isInstanceOf($settings, SettingsInterface::class);

        switch ($setting) {
            case 'enabled':
                return $settings->isEnabled();
            case 'marketing_id':
                return $settings->getMarketingId();
            case 'additional_parameters':
                return $settings->getAdditionalParameters();
            case 'channel_ids':
                return $settings->getChannelIds();
            case 'async_triggers':
                return $settings->getAsyncTriggers();
            case 'async_events':
                return $settings->getAsyncEvents();
            case 'async_reloaded':
                return $settings->isAsyncReloaded();
            case 'async_config':
                return $settings->getAsyncConfig();
            default:
                throw new \InvalidArgumentException(sprintf('Unrecognized Marketing Plugin setting %s', $setting));
        }
    }

    public function isEnabled(): bool
    {
        return (bool) $this->getSetting('enabled');
    }
}
